package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets;

import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.util.LinkedHashMap;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Affichage de l'attribut CKA_VALUE de l'objet
 *
 */
public class AfficheAtttributObjet{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(AfficheAtttributObjet.class);
	
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSession Identifiant de la session
	 * @param idObjet Identifiant de l'obket
	 * @param libelle Libell de l'objet
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSession, long idObjet, String libelle) throws ExceptionTraitement {

		try {
			
			if(librairie != null) {
				
				ResultatInfo resultat = new ResultatInfo("Affichage de l'attribut CKA_VALUE de l'objet \""+libelle+"\" (C_GetAttributeValue)");
				LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
				resultat.setInfos(infos);
				
				try {
					
					CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[1];
					attributes[0] = new CK_ATTRIBUTE();
					attributes[0].type = PKCS11Constants.CKA_VALUE;			
					
					// Traitement  tester
					librairie.C_GetAttributeValue(idSession, idObjet, attributes);
		
					// Formatage du rsultat
					if(attributes != null) {
						
						try {
							
							infos.put("Valeur de l'attribut CKA_VALUE","\n"+TraitementsUtil.getHexadecimal((byte[])attributes[0].pValue,16));
							
						} catch(ClassCastException e) {
							
							// Si une erreur de cast survient on lve l'exception
							log.error("Erreur de cast : "+e.getMessage());
							throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_AFFICHE_ATTRIBUT, "Une erreur inattendue est survenue");
							
						}
						
					} else {
						
						// Si l'ensemble d'attributs retourns est nul on lve l'exception
						log.error("L'operation a retourne un ensemble d'attributs nul");
						throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_AFFICHE_ATTRIBUT, "L'operation a retourne un ensemble d'attributs nul");
						
					}
					
				} catch (PKCS11Exception e) {
					
					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
				
				return resultat;
				
			} else {
				
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_AFFICHE_ATTRIBUT, "La librairie est nulle");
				
			}
			
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_AFFICHE_ATTRIBUT, "Une erreur inattendue est survenue");
			
		}
	
	}

}
